/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.fw.ntfy.DescriptiveObject;
import com.ibm.hwmca.fw.ntfy.TextBasedEvent;
import com.ibm.hwmca.fw.ntfy.TextField;
import java.io.Serializable;
import java.util.EventObject;

public abstract class TextFilter
extends DescriptiveObject
implements Serializable {
    static final long serialVersionUID = -4019336499599921706L;
    public static final int FIRST_BINARY_OP = 0;
    public static final int OP_EQUALS = 0;
    public static final int OP_NOT_EQUALS = 1;
    public static final int OP_AFTER = 2;
    public static final int OP_BEFORE = 3;
    public static final int OP_GREATER_THAN = 4;
    public static final int OP_LESS_THAN = 5;
    public static final int OP_GREATER_THAN_OR_EQUAL = 6;
    public static final int OP_LESS_THAN_OR_EQUAL = 7;
    public static final int OP_MATCHES = 8;
    public static final int OP_DONT_CARE = 9;
    public static final int LAST_BINARY_OP = 9;
    public static final int FIRST_TERTIARY_OP = 100;
    public static final int OP_BETWEEN = 100;
    public static final int OP_NOT_BETWEEN = 101;
    public static final int LAST_TERTIARY_OP = 101;
    public static final int FIRST_MULTI_OP = 1000;
    public static final int OP_IN = 1000;
    public static final int OP_NOT_IN = 1001;
    public static final int LAST_MULTI_OP = 1001;
    protected TextField _field;
    protected int _operation;
    protected String _operand;

    public static boolean isBinaryOp(int op) {
        return 0 <= op && op <= 9;
    }

    public static boolean isTertiaryOp(int op) {
        return 100 <= op && op <= 101;
    }

    public static boolean isMultiOp(int op) {
        return 1000 <= op && op <= 1001;
    }

    public static boolean isRegularExpressionOp(int op) {
        return op == 8;
    }

    public static boolean isLegalOp(int op) {
        return TextFilter.isBinaryOp(op) || TextFilter.isTertiaryOp(op) || TextFilter.isMultiOp(op);
    }

    public static boolean isLegalOp(int op, int[] legalOps) {
        for (int i = 0; i < legalOps.length; ++i) {
            if (op != legalOps[i]) continue;
            return true;
        }
        return false;
    }

    TextFilter() {
    }

    public TextFilter(String name, int operation, String operand, TextField field) {
        super(name, "");
        if (!TextFilter.isLegalOp(operation)) {
            throw new IllegalArgumentException("Unknown operation:  " + operation);
        }
        if (operand == null) {
            throw new IllegalArgumentException("Null operand is not permitted.");
        }
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this._field = field;
        this._operation = operation;
        this._operand = operand;
    }

    public TextField getField() {
        return this._field;
    }

    public int getOperation() {
        return this._operation;
    }

    public String getOperand() {
        return this._operand;
    }

    public String getFieldData(String data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("Text filters require String data.");
        }
        return this._field.getSubstring(data);
    }

    public abstract boolean validateData(int var1, String var2);

    public boolean pass(EventObject event) {
        return super.pass(event) && event instanceof TextBasedEvent;
    }
}

